<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sku extends Model 
{

    protected $table = 'skus';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'barcode', 'price');

    public function variantValues()
    {
        return $this->belongsToMany('App\Models\ProductVariantValue')->withTimestamps();
    }

    public function locations()
    {
        return $this->belongsToMany('App\Models\Location')->withTimestamps()->withPivot('quantity');
    }

    public function images()
    {
        return $this->hasMany('App\Models\SkuImage');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction');
    }

}